/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.vterm;

import com.ibm.hsc.vterm.PIHSCVtermPacketThread;
import com.ibm.hsc.vterm.VSerialSessionIfc;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.Timestamp;

class PIHSCVtermReader
implements VSerialSessionIfc {
    private DataOutputStream vtermoutsoc = null;
    private Socket socket = null;
    private PIHSCVtermPacketThread writethread;
    private int openTryCount = 0;
    public static final int MAX_FILESIZE = 4096000;
    public static final int MAX_OPEN_ATTEMPTS = 3;
    public int currentState = 1;

    public PIHSCVtermReader(PIHSCVtermPacketThread pIHSCVtermPacketThread) {
        this.vtermoutsoc = pIHSCVtermPacketThread.vtermoutsoc;
        this.socket = pIHSCVtermPacketThread.socket;
        this.writethread = pIHSCVtermPacketThread;
    }

    public int getState() {
        return this.currentState;
    }

    public int getOpenCount() {
        return this.openTryCount;
    }

    public void setOpenCount(int n) {
        this.openTryCount = n;
    }

    public void sessionStateChanged(int n, int[] nArray) {
        System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " state changing from " + this.currentState + " to " + n);
        if (nArray != null) {
            System.out.println("lparId:" + this.writethread.lparId + " params are " + nArray);
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println("lparId:" + this.writethread.lparId + " error parm[" + i + "] = 0x" + Integer.toHexString(nArray[i]));
            }
        }
        this.currentState = n;
        block0 : switch (n) {
            case 1: {
                System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " session closed\n");
                String string = "\r\n Connection has closed \r\n";
                this.VTsessionMessage(string);
                break;
            }
            case 2: {
                System.out.println(this.writethread.cfgString + "    lparId:" + this.writethread.lparId + " session open pending\n");
                break;
            }
            case 3: {
                System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " session open\n");
                break;
            }
            case 4: {
                System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " session error \n");
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " error parm[" + i + "] = 0x" + Integer.toHexString(nArray[i]));
                    }
                    switch (nArray[0]) {
                        case 6: {
                            System.out.println("HS_MIN_VSERIAL_OPEN_FAILURE openTryCount= " + this.openTryCount);
                            System.out.println("parms[1] = " + nArray[1]);
                            if (this.openTryCount != 3) break block0;
                            String string = "\r\n The open failed. \r\n   -The session may already be open on another management console \r\n   -The server may not be ready to accept connections. \r\n";
                            this.VTsessionMessage(string);
                            break;
                        }
                        case 9: {
                            System.out.println("HS_MIN_VSERIAL_CLOSE_FAILURE");
                            break;
                        }
                        case 12: {
                            System.out.println("HS_MIN_VSERIAL_WRITE_FAILURE");
                            String string = "\r\n Error in communication path to the partition \r\n";
                            this.VTsessionMessage(string);
                            break;
                        }
                        case 98: {
                            System.out.println("HS_MIN_FSP_ERR");
                            String string = "\r\n Error in communication path to the partition \r\n";
                            this.VTsessionMessage(string);
                            break;
                        }
                        case 3: {
                            System.out.println("HS_MIN_VSERIAL_LIST_FAILURE");
                            String string = "\r\n Internal error encountered \r\n";
                            this.VTsessionMessage(string);
                            break;
                        }
                        default: {
                            System.out.println("Should not get here");
                            break;
                        }
                    }
                    break;
                }
                System.out.println("Parms are null..unexpected");
                break;
            }
            case 5: {
                System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " session close pending\n");
                break;
            }
            default: {
                System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " unknown session state\n");
            }
        }
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println("lparId:" + this.writethread.lparId + "State change:  error parm[" + i + "] = 0x" + Integer.toHexString(nArray[i]));
            }
        } else {
            System.out.println("lparId:" + this.writethread.lparId + " No params sent for state change");
        }
    }

    public void VTsessionMessage(String string) {
        block2: {
            try {
                System.out.println("lparId:" + this.writethread.lparId + " VTsessionMessage writing =" + string);
                this.vtermoutsoc.writeChars(string);
                this.vtermoutsoc.flush();
            }
            catch (IOException iOException) {
                if (!this.writethread.debugOn) break block2;
                System.out.println(this.writethread.cfgString + "lparId:" + this.writethread.lparId + " ** Io Excption in Reader sessClosed " + " catch while closing socket");
            }
        }
    }

    public void incomingData(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return;
        }
        try {
            String string = new String(byArray, n, n2);
            this.vtermoutsoc.write(byArray, n, n2);
            this.vtermoutsoc.flush();
            if (this.writethread.debugOn) {
                System.out.print(new Timestamp(System.currentTimeMillis()));
                System.out.println(" " + this.writethread.cfgString + " " + this.writethread.lparId + " FROM  CSP: " + string);
            }
            if (this.writethread.logit) {
                if (this.writethread.outFile.getFilePointer() > 4096000L) {
                    this.writethread.outFile.seek(0L);
                    this.writethread.pwriter.println("This log has wrapped " + ++n3 + " time(s).\r\n\r\n");
                }
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c >= ' ' && c <= '~' || c == '\t' || c == '\r') {
                        if (c == '\r') {
                            this.writethread.pwriter.println(c);
                        } else {
                            this.writethread.pwriter.print(c);
                        }
                    }
                    this.writethread.pwriter.flush();
                }
            }
        }
        catch (Throwable throwable) {
            if (this.writethread.debugOn) {
                System.out.println(this.writethread.cfgString + "  lparId:" + this.writethread.lparId + " Reader: connection closed");
            }
            String string = "\r\n Connection has closed \r\n";
            this.VTsessionMessage(string);
            this.writethread.helper.close(this.writethread.vport, this.writethread._lparId, this.writethread._sessionId, true);
            this.writethread.cleanup();
        }
    }
}

